﻿-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'NB_Channel'
CREATE TABLE [dbo].[NB_Channel] (
    [ChannelID] int IDENTITY(1,1) NOT NULL,
    [ParentChannelID] int  NULL,
    [Name] nvarchar(max)  NOT NULL,
    [BreakRightsInherit] bit  NOT NULL,
    [SortOrder] int  NOT NULL,
    [CanContainItems] bit  NOT NULL
);
GO

-- Creating table 'NB_ChannelRights'
CREATE TABLE [dbo].[NB_ChannelRights] (
    [ChannelRightsID] int IDENTITY(1,1) NOT NULL,
    [ChannelID] int  NOT NULL,
    [PrincipalID] int  NOT NULL,
    [Level] int  NOT NULL
);
GO

-- Creating table 'NB_ChannelSet'
CREATE TABLE [dbo].[NB_ChannelSet] (
    [ChannelSetID] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Properties] nvarchar(max)  NULL,
    [Shared] bit  NOT NULL
);
GO

-- Creating table 'NB_ContentType'
CREATE TABLE [dbo].[NB_ContentType] (
    [ContentTypeID] int IDENTITY(1,1) NOT NULL,
    [ExtendedProperties] nvarchar(max)  NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Active] bit  NOT NULL
);
GO

-- Creating table 'NB_Device'
CREATE TABLE [dbo].[NB_Device] (
    [DeviceID] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'NB_Item'
CREATE TABLE [dbo].[NB_Item] (
    [ItemID] int IDENTITY(1,1) NOT NULL,
    [Startdate] datetimeoffset  NOT NULL,
    [Enddate] datetimeoffset  NOT NULL,
    [Heading] nvarchar(max)  NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [AuthorID] int  NOT NULL,
    [AlternateAuthorID] int  NULL,
    [ExtendedProperties] nvarchar(max)  NULL,
    [ContentTypeID] int  NOT NULL
);
GO

-- Creating table 'NB_Mandatory'
CREATE TABLE [dbo].[NB_Mandatory] (
    [ChannelID] int  NOT NULL,
    [PrincipalID] int  NOT NULL,
    [ChannelSetID] int  NOT NULL
);
GO

-- Creating table 'NB_NotificationLog'
CREATE TABLE [dbo].[NB_NotificationLog] (
    [ItemID] int  NOT NULL,
    [PrincipalID] int  NOT NULL,
    [DeviceID] int  NOT NULL,
    [Timestamp] datetimeoffset  NOT NULL
);
GO

-- Creating table 'NB_Personal'
CREATE TABLE [dbo].[NB_Personal] (
    [PrincipalID] int  NOT NULL,
    [ChannelID] int  NOT NULL,
    [ChannelSetID] int  NOT NULL
);
GO

-- Creating table 'NB_Principal'
CREATE TABLE [dbo].[NB_Principal] (
    [PrincipalID] int IDENTITY(1,1) NOT NULL,
    [Type] int  NOT NULL,
    [DisplayName] nvarchar(max)  NOT NULL,
    [GroupId] uniqueidentifier  NULL,
    [LoginName] nvarchar(max)  NULL
);
GO

-- Creating table 'NB_Read'
CREATE TABLE [dbo].[NB_Read] (
    [ItemID] int  NOT NULL,
    [PrincipalID] int  NOT NULL,
    [Timestamp] datetimeoffset  NOT NULL
);
GO

-- Creating table 'NB_View'
CREATE TABLE [dbo].[NB_View] (
    [ChannelSetID] int  NOT NULL,
    [DeviceID] int  NOT NULL,
    [ViewID] uniqueidentifier  NOT NULL,
    [ExtendedProperties] nvarchar(max)  NULL
);
GO

-- Creating table 'Cache'
IF OBJECT_ID(N'dbo.Cache', N'U') IS NULL BEGIN
	CREATE TABLE [dbo].[Cache] (
		[Modul] nvarchar(50)  NOT NULL,
		[Key] nvarchar(300)  NOT NULL,
		[Value] varbinary(max)  NOT NULL,
		[Inserted] datetime  NOT NULL,
		[Updated] datetime  NOT NULL,
		[Type] nvarchar(max)  NOT NULL
	);
END
GO

-- Creating table 'WebpartProperty'
CREATE TABLE [dbo].[WebpartProperty] (
    [Modul] nvarchar(50)  NOT NULL,
    [WebpartId] uniqueidentifier  NOT NULL,
    [Key] nvarchar(300)  NOT NULL,
    [Value] nvarchar(max)  NOT NULL,
    [PageId] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'NB_Settings'
CREATE TABLE [dbo].[NB_Settings] (
    [Key] nvarchar(50)  NOT NULL,
    [Value] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'NB_Suggested'
CREATE TABLE [dbo].[NB_Suggested] (
    [SuggestedID] int IDENTITY(1,1) NOT NULL,
    [ChannelID] int  NOT NULL,
    [PrincipalID] int  NOT NULL,
    [ChannelSetID] int  NOT NULL
);
GO

-- Creating table 'NB_SuggestedDeny'
CREATE TABLE [dbo].[NB_SuggestedDeny] (
    [NB_PrincipalID] int  NOT NULL,
    [NB_ChannelSetID] int  NOT NULL,
    [NB_ChannelId] int  NOT NULL
);
GO

-- Creating table 'Manual'
CREATE TABLE [dbo].[Manual] (
    [PageId] nvarchar(100)  NOT NULL,
    [PageVersion] nvarchar(50)  NOT NULL,
    [Email] nvarchar(100)  NOT NULL,
    [TimeStamp] datetime  NULL,
    [PageFinder] nvarchar(max)  NULL,
    [Stars] int  NULL
);
GO

-- Creating table 'NB_Comment'
CREATE TABLE [dbo].[NB_Comment] (
    [CommentID] int IDENTITY(1,1) NOT NULL,
    [AuthorID] int  NOT NULL,
    [ItemID] int  NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [DatePosted] datetimeoffset  NOT NULL,
    [DateModified] datetimeoffset  NULL,
    [Preview] bit  NULL,
    [Status] int  NOT NULL,
    [Picture] nvarchar(max)  NULL
);
GO

-- Creating table 'NB_Like'
CREATE TABLE [dbo].[NB_Like] (
    [LikeID] int IDENTITY(1,1) NOT NULL,
    [PrincipalID] int  NOT NULL,
    [CommentID] int  NULL,
    [ItemID] int  NULL,
    [Timestamp] datetimeoffset  NOT NULL
);
GO

-- Creating table 'Version'
CREATE TABLE [dbo].[Version] (
    [Major] int  NOT NULL,
    [Minor] int  NOT NULL
);
GO

-- Creating table 'NB_Channel_ContentType'
CREATE TABLE [dbo].[NB_Channel_ContentType] (
    [NB_Channel_ChannelID] int  NOT NULL,
    [NB_ContentType_ContentTypeID] int  NOT NULL
);
GO

-- Creating table 'NB_Channel_Item'
CREATE TABLE [dbo].[NB_Channel_Item] (
    [NB_Channel_ChannelID] int  NOT NULL,
    [NB_Item_ItemID] int  NOT NULL
);
GO

-- Creating table 'NB_ViewOnlyShowChannels'
CREATE TABLE [dbo].[NB_ViewOnlyShowChannels] (
    [NB_OnlyShowChannels_ChannelID] int  NOT NULL,
    [NB_ChannelSet_ChannelSetID] int  NOT NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [ChannelID] in table 'NB_Channel'
ALTER TABLE [dbo].[NB_Channel]
ADD CONSTRAINT [PK_NB_Channel]
    PRIMARY KEY CLUSTERED ([ChannelID] ASC);
GO

-- Creating primary key on [ChannelRightsID] in table 'NB_ChannelRights'
ALTER TABLE [dbo].[NB_ChannelRights]
ADD CONSTRAINT [PK_NB_ChannelRights]
    PRIMARY KEY CLUSTERED ([ChannelRightsID] ASC);
GO

-- Creating primary key on [ChannelSetID] in table 'NB_ChannelSet'
ALTER TABLE [dbo].[NB_ChannelSet]
ADD CONSTRAINT [PK_NB_ChannelSet]
    PRIMARY KEY CLUSTERED ([ChannelSetID] ASC);
GO

-- Creating primary key on [ContentTypeID] in table 'NB_ContentType'
ALTER TABLE [dbo].[NB_ContentType]
ADD CONSTRAINT [PK_NB_ContentType]
    PRIMARY KEY CLUSTERED ([ContentTypeID] ASC);
GO

-- Creating primary key on [DeviceID] in table 'NB_Device'
ALTER TABLE [dbo].[NB_Device]
ADD CONSTRAINT [PK_NB_Device]
    PRIMARY KEY CLUSTERED ([DeviceID] ASC);
GO

-- Creating primary key on [ItemID] in table 'NB_Item'
ALTER TABLE [dbo].[NB_Item]
ADD CONSTRAINT [PK_NB_Item]
    PRIMARY KEY CLUSTERED ([ItemID] ASC);
GO

-- Creating primary key on [ChannelID], [PrincipalID], [ChannelSetID] in table 'NB_Mandatory'
ALTER TABLE [dbo].[NB_Mandatory]
ADD CONSTRAINT [PK_NB_Mandatory]
    PRIMARY KEY CLUSTERED ([ChannelID], [PrincipalID], [ChannelSetID] ASC);
GO

-- Creating primary key on [ItemID], [PrincipalID], [DeviceID] in table 'NB_NotificationLog'
ALTER TABLE [dbo].[NB_NotificationLog]
ADD CONSTRAINT [PK_NB_NotificationLog]
    PRIMARY KEY CLUSTERED ([ItemID], [PrincipalID], [DeviceID] ASC);
GO

-- Creating primary key on [PrincipalID], [ChannelID], [ChannelSetID] in table 'NB_Personal'
ALTER TABLE [dbo].[NB_Personal]
ADD CONSTRAINT [PK_NB_Personal]
    PRIMARY KEY CLUSTERED ([PrincipalID], [ChannelID], [ChannelSetID] ASC);
GO

-- Creating primary key on [PrincipalID] in table 'NB_Principal'
ALTER TABLE [dbo].[NB_Principal]
ADD CONSTRAINT [PK_NB_Principal]
    PRIMARY KEY CLUSTERED ([PrincipalID] ASC);
GO

-- Creating primary key on [ItemID], [PrincipalID] in table 'NB_Read'
ALTER TABLE [dbo].[NB_Read]
ADD CONSTRAINT [PK_NB_Read]
    PRIMARY KEY CLUSTERED ([ItemID], [PrincipalID] ASC);
GO

-- Creating primary key on [ViewID] in table 'NB_View'
ALTER TABLE [dbo].[NB_View]
ADD CONSTRAINT [PK_NB_View]
    PRIMARY KEY CLUSTERED ([ViewID] ASC);
GO

-- Creating primary key on [Modul], [Key] in table 'Cache'
ALTER TABLE [dbo].[Cache]
ADD CONSTRAINT [PK_Cache]
    PRIMARY KEY CLUSTERED ([Modul], [Key] ASC);
GO

-- Creating primary key on [WebpartId], [Key] in table 'WebpartProperty'
ALTER TABLE [dbo].[WebpartProperty]
ADD CONSTRAINT [PK_WebpartProperty]
    PRIMARY KEY CLUSTERED ([WebpartId], [Key] ASC);
GO

-- Creating primary key on [Key] in table 'NB_Settings'
ALTER TABLE [dbo].[NB_Settings]
ADD CONSTRAINT [PK_NB_Settings]
    PRIMARY KEY CLUSTERED ([Key] ASC);
GO

-- Creating primary key on [SuggestedID] in table 'NB_Suggested'
ALTER TABLE [dbo].[NB_Suggested]
ADD CONSTRAINT [PK_NB_Suggested]
    PRIMARY KEY CLUSTERED ([SuggestedID] ASC);
GO

-- Creating primary key on [NB_PrincipalID], [NB_ChannelSetID], [NB_ChannelId] in table 'NB_SuggestedDeny'
ALTER TABLE [dbo].[NB_SuggestedDeny]
ADD CONSTRAINT [PK_NB_SuggestedDeny]
    PRIMARY KEY CLUSTERED ([NB_PrincipalID], [NB_ChannelSetID], [NB_ChannelId] ASC);
GO

-- Creating primary key on [PageId], [Email] in table 'Manual'
ALTER TABLE [dbo].[Manual]
ADD CONSTRAINT [PK_Manual]
    PRIMARY KEY CLUSTERED ([PageId], [Email] ASC);
GO

-- Creating primary key on [CommentID] in table 'NB_Comment'
ALTER TABLE [dbo].[NB_Comment]
ADD CONSTRAINT [PK_NB_Comment]
    PRIMARY KEY CLUSTERED ([CommentID] ASC);
GO

-- Creating primary key on [LikeID] in table 'NB_Like'
ALTER TABLE [dbo].[NB_Like]
ADD CONSTRAINT [PK_NB_Like]
    PRIMARY KEY CLUSTERED ([LikeID] ASC);
GO

-- Creating primary key on [Major], [Minor] in table 'Version'
ALTER TABLE [dbo].[Version]
ADD CONSTRAINT [PK_Version]
    PRIMARY KEY CLUSTERED ([Major], [Minor] ASC);
GO

-- Creating primary key on [NB_Channel_ChannelID], [NB_ContentType_ContentTypeID] in table 'NB_Channel_ContentType'
ALTER TABLE [dbo].[NB_Channel_ContentType]
ADD CONSTRAINT [PK_NB_Channel_ContentType]
    PRIMARY KEY CLUSTERED ([NB_Channel_ChannelID], [NB_ContentType_ContentTypeID] ASC);
GO

-- Creating primary key on [NB_Channel_ChannelID], [NB_Item_ItemID] in table 'NB_Channel_Item'
ALTER TABLE [dbo].[NB_Channel_Item]
ADD CONSTRAINT [PK_NB_Channel_Item]
    PRIMARY KEY CLUSTERED ([NB_Channel_ChannelID], [NB_Item_ItemID] ASC);
GO

-- Creating primary key on [NB_OnlyShowChannels_ChannelID], [NB_ChannelSet_ChannelSetID] in table 'NB_ViewOnlyShowChannels'
ALTER TABLE [dbo].[NB_ViewOnlyShowChannels]
ADD CONSTRAINT [PK_NB_ViewOnlyShowChannels]
    PRIMARY KEY CLUSTERED ([NB_OnlyShowChannels_ChannelID], [NB_ChannelSet_ChannelSetID] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [ChannelID] in table 'NB_Personal'
ALTER TABLE [dbo].[NB_Personal]
ADD CONSTRAINT [FK_NB_Personal_NB_Channel]
    FOREIGN KEY ([ChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Personal_NB_Channel'
CREATE INDEX [IX_FK_NB_Personal_NB_Channel]
ON [dbo].[NB_Personal]
    ([ChannelID]);
GO

-- Creating foreign key on [ParentChannelID] in table 'NB_Channel'
ALTER TABLE [dbo].[NB_Channel]
ADD CONSTRAINT [FK_NoticeboardChannel_NoticeboardChannel]
    FOREIGN KEY ([ParentChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardChannel_NoticeboardChannel'
CREATE INDEX [IX_FK_NoticeboardChannel_NoticeboardChannel]
ON [dbo].[NB_Channel]
    ([ParentChannelID]);
GO

-- Creating foreign key on [ChannelID] in table 'NB_ChannelRights'
ALTER TABLE [dbo].[NB_ChannelRights]
ADD CONSTRAINT [FK_NoticeboardChannelRights_NoticeboardChannel]
    FOREIGN KEY ([ChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardChannelRights_NoticeboardChannel'
CREATE INDEX [IX_FK_NoticeboardChannelRights_NoticeboardChannel]
ON [dbo].[NB_ChannelRights]
    ([ChannelID]);
GO

-- Creating foreign key on [ChannelID] in table 'NB_Mandatory'
ALTER TABLE [dbo].[NB_Mandatory]
ADD CONSTRAINT [FK_NoticeboardMandatory_NoticeboardChannel]
    FOREIGN KEY ([ChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [PrincipalID] in table 'NB_ChannelRights'
ALTER TABLE [dbo].[NB_ChannelRights]
ADD CONSTRAINT [FK_NoticeboardChannelRights_NoticeboardPrincipal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardChannelRights_NoticeboardPrincipal'
CREATE INDEX [IX_FK_NoticeboardChannelRights_NoticeboardPrincipal]
ON [dbo].[NB_ChannelRights]
    ([PrincipalID]);
GO

-- Creating foreign key on [ChannelSetID] in table 'NB_View'
ALTER TABLE [dbo].[NB_View]
ADD CONSTRAINT [FK_NB_ChannelSet_Device_NB_ChannelSet]
    FOREIGN KEY ([ChannelSetID])
    REFERENCES [dbo].[NB_ChannelSet]
        ([ChannelSetID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_ChannelSet_Device_NB_ChannelSet'
CREATE INDEX [IX_FK_NB_ChannelSet_Device_NB_ChannelSet]
ON [dbo].[NB_View]
    ([ChannelSetID]);
GO

-- Creating foreign key on [ChannelSetID] in table 'NB_Personal'
ALTER TABLE [dbo].[NB_Personal]
ADD CONSTRAINT [FK_NB_Personal_NB_ChannelSet1]
    FOREIGN KEY ([ChannelSetID])
    REFERENCES [dbo].[NB_ChannelSet]
        ([ChannelSetID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Personal_NB_ChannelSet1'
CREATE INDEX [IX_FK_NB_Personal_NB_ChannelSet1]
ON [dbo].[NB_Personal]
    ([ChannelSetID]);
GO

-- Creating foreign key on [ChannelSetID] in table 'NB_Mandatory'
ALTER TABLE [dbo].[NB_Mandatory]
ADD CONSTRAINT [FK_NoticeboardMandatory_NoticeboardViewProperties]
    FOREIGN KEY ([ChannelSetID])
    REFERENCES [dbo].[NB_ChannelSet]
        ([ChannelSetID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardMandatory_NoticeboardViewProperties'
CREATE INDEX [IX_FK_NoticeboardMandatory_NoticeboardViewProperties]
ON [dbo].[NB_Mandatory]
    ([ChannelSetID]);
GO

-- Creating foreign key on [ContentTypeID] in table 'NB_Item'
ALTER TABLE [dbo].[NB_Item]
ADD CONSTRAINT [FK_NoticeboardItem_NoticeboardContentType]
    FOREIGN KEY ([ContentTypeID])
    REFERENCES [dbo].[NB_ContentType]
        ([ContentTypeID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardItem_NoticeboardContentType'
CREATE INDEX [IX_FK_NoticeboardItem_NoticeboardContentType]
ON [dbo].[NB_Item]
    ([ContentTypeID]);
GO

-- Creating foreign key on [DeviceID] in table 'NB_View'
ALTER TABLE [dbo].[NB_View]
ADD CONSTRAINT [FK_NB_ChannelSet_Device_NB_Device]
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[NB_Device]
        ([DeviceID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_ChannelSet_Device_NB_Device'
CREATE INDEX [IX_FK_NB_ChannelSet_Device_NB_Device]
ON [dbo].[NB_View]
    ([DeviceID]);
GO

-- Creating foreign key on [DeviceID] in table 'NB_NotificationLog'
ALTER TABLE [dbo].[NB_NotificationLog]
ADD CONSTRAINT [FK_NoticeboardNotificationLog_NB_Device]
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[NB_Device]
        ([DeviceID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardNotificationLog_NB_Device'
CREATE INDEX [IX_FK_NoticeboardNotificationLog_NB_Device]
ON [dbo].[NB_NotificationLog]
    ([DeviceID]);
GO

-- Creating foreign key on [ItemID] in table 'NB_NotificationLog'
ALTER TABLE [dbo].[NB_NotificationLog]
ADD CONSTRAINT [FK_NB_NotificationLog_NB_Item]
    FOREIGN KEY ([ItemID])
    REFERENCES [dbo].[NB_Item]
        ([ItemID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [ItemID] in table 'NB_Read'
ALTER TABLE [dbo].[NB_Read]
ADD CONSTRAINT [FK_NB_Read_NB_Item]
    FOREIGN KEY ([ItemID])
    REFERENCES [dbo].[NB_Item]
        ([ItemID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [PrincipalID] in table 'NB_NotificationLog'
ALTER TABLE [dbo].[NB_NotificationLog]
ADD CONSTRAINT [FK_NoticeboardNotificationLog_NoticeboardPrincipal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardNotificationLog_NoticeboardPrincipal'
CREATE INDEX [IX_FK_NoticeboardNotificationLog_NoticeboardPrincipal]
ON [dbo].[NB_NotificationLog]
    ([PrincipalID]);
GO

-- Creating foreign key on [PrincipalID] in table 'NB_Read'
ALTER TABLE [dbo].[NB_Read]
ADD CONSTRAINT [FK_NoticeboardRead_NoticeboardPrincipal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardRead_NoticeboardPrincipal'
CREATE INDEX [IX_FK_NoticeboardRead_NoticeboardPrincipal]
ON [dbo].[NB_Read]
    ([PrincipalID]);
GO

-- Creating foreign key on [NB_Channel_ChannelID] in table 'NB_Channel_ContentType'
ALTER TABLE [dbo].[NB_Channel_ContentType]
ADD CONSTRAINT [FK_NB_Channel_ContentType_NB_Channel]
    FOREIGN KEY ([NB_Channel_ChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [NB_ContentType_ContentTypeID] in table 'NB_Channel_ContentType'
ALTER TABLE [dbo].[NB_Channel_ContentType]
ADD CONSTRAINT [FK_NB_Channel_ContentType_NB_ContentType]
    FOREIGN KEY ([NB_ContentType_ContentTypeID])
    REFERENCES [dbo].[NB_ContentType]
        ([ContentTypeID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Channel_ContentType_NB_ContentType'
CREATE INDEX [IX_FK_NB_Channel_ContentType_NB_ContentType]
ON [dbo].[NB_Channel_ContentType]
    ([NB_ContentType_ContentTypeID]);
GO

-- Creating foreign key on [NB_Channel_ChannelID] in table 'NB_Channel_Item'
ALTER TABLE [dbo].[NB_Channel_Item]
ADD CONSTRAINT [FK_NB_Channel_Item_NB_Channel]
    FOREIGN KEY ([NB_Channel_ChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [NB_Item_ItemID] in table 'NB_Channel_Item'
ALTER TABLE [dbo].[NB_Channel_Item]
ADD CONSTRAINT [FK_NB_Channel_Item_NB_Item]
    FOREIGN KEY ([NB_Item_ItemID])
    REFERENCES [dbo].[NB_Item]
        ([ItemID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Channel_Item_NB_Item'
CREATE INDEX [IX_FK_NB_Channel_Item_NB_Item]
ON [dbo].[NB_Channel_Item]
    ([NB_Item_ItemID]);
GO

-- Creating foreign key on [NB_OnlyShowChannels_ChannelID] in table 'NB_ViewOnlyShowChannels'
ALTER TABLE [dbo].[NB_ViewOnlyShowChannels]
ADD CONSTRAINT [FK_NB_ViewOnlyShowChannels_NB_Channel]
    FOREIGN KEY ([NB_OnlyShowChannels_ChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [NB_ChannelSet_ChannelSetID] in table 'NB_ViewOnlyShowChannels'
ALTER TABLE [dbo].[NB_ViewOnlyShowChannels]
ADD CONSTRAINT [FK_NB_ViewOnlyShowChannels_NB_ChannelSet]
    FOREIGN KEY ([NB_ChannelSet_ChannelSetID])
    REFERENCES [dbo].[NB_ChannelSet]
        ([ChannelSetID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_ViewOnlyShowChannels_NB_ChannelSet'
CREATE INDEX [IX_FK_NB_ViewOnlyShowChannels_NB_ChannelSet]
ON [dbo].[NB_ViewOnlyShowChannels]
    ([NB_ChannelSet_ChannelSetID]);
GO

-- Creating foreign key on [PrincipalID] in table 'NB_Mandatory'
ALTER TABLE [dbo].[NB_Mandatory]
ADD CONSTRAINT [FK_NB_Mandatory_NB_Principal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Mandatory_NB_Principal'
CREATE INDEX [IX_FK_NB_Mandatory_NB_Principal]
ON [dbo].[NB_Mandatory]
    ([PrincipalID]);
GO

-- Creating foreign key on [PrincipalID] in table 'NB_Personal'
ALTER TABLE [dbo].[NB_Personal]
ADD CONSTRAINT [FK_NB_Personal_NB_Principal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [AuthorID] in table 'NB_Item'
ALTER TABLE [dbo].[NB_Item]
ADD CONSTRAINT [FK_NB_Item_NB_Principal]
    FOREIGN KEY ([AuthorID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Item_NB_Principal'
CREATE INDEX [IX_FK_NB_Item_NB_Principal]
ON [dbo].[NB_Item]
    ([AuthorID]);
GO

-- Creating foreign key on [AlternateAuthorID] in table 'NB_Item'
ALTER TABLE [dbo].[NB_Item]
ADD CONSTRAINT [FK_NB_Item_NB_Principal1]
    FOREIGN KEY ([AlternateAuthorID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Item_NB_Principal1'
CREATE INDEX [IX_FK_NB_Item_NB_Principal1]
ON [dbo].[NB_Item]
    ([AlternateAuthorID]);
GO

-- Creating foreign key on [NB_ChannelId] in table 'NB_SuggestedDeny'
ALTER TABLE [dbo].[NB_SuggestedDeny]
ADD CONSTRAINT [FK_NB_SuggestedDeny_NB_Channel]
    FOREIGN KEY ([NB_ChannelId])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_SuggestedDeny_NB_Channel'
CREATE INDEX [IX_FK_NB_SuggestedDeny_NB_Channel]
ON [dbo].[NB_SuggestedDeny]
    ([NB_ChannelId]);
GO

-- Creating foreign key on [ChannelID] in table 'NB_Suggested'
ALTER TABLE [dbo].[NB_Suggested]
ADD CONSTRAINT [FK_NoticeboardSuggested_NoticeboardChannel]
    FOREIGN KEY ([ChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardSuggested_NoticeboardChannel'
CREATE INDEX [IX_FK_NoticeboardSuggested_NoticeboardChannel]
ON [dbo].[NB_Suggested]
    ([ChannelID]);
GO

-- Creating foreign key on [NB_ChannelSetID] in table 'NB_SuggestedDeny'
ALTER TABLE [dbo].[NB_SuggestedDeny]
ADD CONSTRAINT [FK_NB_SuggestedDeny_NB_ChannelSet]
    FOREIGN KEY ([NB_ChannelSetID])
    REFERENCES [dbo].[NB_ChannelSet]
        ([ChannelSetID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_SuggestedDeny_NB_ChannelSet'
CREATE INDEX [IX_FK_NB_SuggestedDeny_NB_ChannelSet]
ON [dbo].[NB_SuggestedDeny]
    ([NB_ChannelSetID]);
GO

-- Creating foreign key on [ChannelSetID] in table 'NB_Suggested'
ALTER TABLE [dbo].[NB_Suggested]
ADD CONSTRAINT [FK_NoticeboardSuggested_NoticeboardViewProperties]
    FOREIGN KEY ([ChannelSetID])
    REFERENCES [dbo].[NB_ChannelSet]
        ([ChannelSetID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NoticeboardSuggested_NoticeboardViewProperties'
CREATE INDEX [IX_FK_NoticeboardSuggested_NoticeboardViewProperties]
ON [dbo].[NB_Suggested]
    ([ChannelSetID]);
GO

-- Creating foreign key on [PrincipalID] in table 'NB_Suggested'
ALTER TABLE [dbo].[NB_Suggested]
ADD CONSTRAINT [FK_NB_Suggested_NB_Principal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Suggested_NB_Principal'
CREATE INDEX [IX_FK_NB_Suggested_NB_Principal]
ON [dbo].[NB_Suggested]
    ([PrincipalID]);
GO

-- Creating foreign key on [NB_PrincipalID] in table 'NB_SuggestedDeny'
ALTER TABLE [dbo].[NB_SuggestedDeny]
ADD CONSTRAINT [FK_NB_SuggestedDeny_NB_Principal]
    FOREIGN KEY ([NB_PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [ItemID] in table 'NB_Comment'
ALTER TABLE [dbo].[NB_Comment]
ADD CONSTRAINT [FK_NB_Comment_NB_Item]
    FOREIGN KEY ([ItemID])
    REFERENCES [dbo].[NB_Item]
        ([ItemID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Comment_NB_Item'
CREATE INDEX [IX_FK_NB_Comment_NB_Item]
ON [dbo].[NB_Comment]
    ([ItemID]);
GO

-- Creating foreign key on [AuthorID] in table 'NB_Comment'
ALTER TABLE [dbo].[NB_Comment]
ADD CONSTRAINT [FK_NB_Comment_NB_Principal]
    FOREIGN KEY ([AuthorID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Comment_NB_Principal'
CREATE INDEX [IX_FK_NB_Comment_NB_Principal]
ON [dbo].[NB_Comment]
    ([AuthorID]);
GO

-- Creating foreign key on [CommentID] in table 'NB_Like'
ALTER TABLE [dbo].[NB_Like]
ADD CONSTRAINT [FK_NB_Like_NB_Comment]
    FOREIGN KEY ([CommentID])
    REFERENCES [dbo].[NB_Comment]
        ([CommentID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Like_NB_Comment'
CREATE INDEX [IX_FK_NB_Like_NB_Comment]
ON [dbo].[NB_Like]
    ([CommentID]);
GO

-- Creating foreign key on [ItemID] in table 'NB_Like'
ALTER TABLE [dbo].[NB_Like]
ADD CONSTRAINT [FK_NB_Like_NB_Item]
    FOREIGN KEY ([ItemID])
    REFERENCES [dbo].[NB_Item]
        ([ItemID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Like_NB_Item'
CREATE INDEX [IX_FK_NB_Like_NB_Item]
ON [dbo].[NB_Like]
    ([ItemID]);
GO

-- Creating foreign key on [PrincipalID] in table 'NB_Like'
ALTER TABLE [dbo].[NB_Like]
ADD CONSTRAINT [FK_NB_Like_NB_Principal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_Like_NB_Principal'
CREATE INDEX [IX_FK_NB_Like_NB_Principal]
ON [dbo].[NB_Like]
    ([PrincipalID]);
GO

-- --------------------------------------------------
-- Insert values
-- --------------------------------------------------

Insert into [version] values(0,1)

-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------